---
Difficulty: Medium  
Source: Daily-Question (POTD 04-Dec)  
Tags:  
- Strings  
- Two Pointers 
---

# 🚀 **2825 - Make String a Subsequence Using Cyclic Increments** 🧠

### Problem Link:
[**LeetCode - Make String a Subsequence Using Cyclic Increments**](https://leetcode.com/problems/make-string-a-subsequence-using-cyclic-increments/description/?envType=daily-question&envId=2024-12-04)


## 💡 **Problem Breakdown:**

You are given two strings `str1` and `str2`.  
You can perform a single operation on `str1` where you select **one or more indices** and cyclically increment the characters at those indices (e.g., `'z'` → `'a'`, `'a'` → `'b'`).

Return `true` if, after at most one such operation, `str2` becomes a subsequence of `str1`. Otherwise, return `false`.

### Key Observations:
1. **Subsequence Definition:**  
   A subsequence is a string derived from another string by deleting some or no characters without changing their order.

2. **Cyclic Increment:**  
   Each character in `str1` can be shifted to any other character through cyclic increments.

3. **Single Operation:**  
   You can perform cyclic increments on any subset of indices in `str1` **at most once**.


## 🔍 **Example Walkthrough:**

### Example 1:

**Input:**  
`str1 = "abc", str2 = "ad"`  

**Output:**  
`true`

**Explanation:**  
- Select index `2` in `str1`. Increment `str1[2]` from `'c'` to `'d'`.  
- Now `str1` becomes `"abd"`.  
- Since `str2 = "ad"` is a subsequence of `"abd"`, the result is `true`.


### Example 2:

**Input:**  
`str1 = "zc", str2 = "ad"`  

**Output:**  
`true`

**Explanation:**  
- Select indices `0` and `1`. Increment:
  - `str1[0]` from `'z'` to `'a'`.  
  - `str1[1]` from `'c'` to `'d'`.  
- Now `str1` becomes `"ad"`.  
- Since `str2 = "ad"` is a subsequence of `"ad"`, the result is `true`.


### Example 3:

**Input:**  
`str1 = "ab", str2 = "d"`  

**Output:**  
`false`

**Explanation:**  
- There is no way to increment characters in `str1` to make `str2 = "d"` a subsequence.  


## 🎯 **My Approach:**

1. **Two-Pointer Technique:**  
   Use two pointers to compare characters of `str1` and `str2`:
   - Traverse `str1` and `str2` simultaneously.
   - Check if the current character in `str1` can be **incremented cyclically** to match the current character in `str2`.

2. **Conditions for a Match:**  
   - If `str1[i] <= str2[j]`: They already match in sequence. Move both pointers.  
   - If `str1[i] > str2[j]`: Check if incrementing `str1[i]` cyclically can eventually match `str2[j]`.

3. **Edge Cases:**  
   - If `str1` is shorter than `str2`, the answer is always `false`.
   - Handle wrapping (`'z' → 'a'`) correctly.

4. **Termination:**  
   If all characters in `str2` are matched, return `true`. If `str1` is exhausted and `str2` still has unmatched characters, return `false`.


## 🕒 **Time Complexity:**
- **O(n):**  
  Each character in `str1` and `str2` is processed at most once using two pointers.  
- **Space Complexity:**  
  **O(1):** No extra space is used apart from pointers.

## 📝 **Solution Code**

## Code (C):

```c
bool canMakeSubsequence(char* str1, char* str2) {
    int j = 0;
    for (int i = 0; str1[i] != '\0' && str2[j] != '\0'; ++i) {
        if (str1[i] == str2[j] || (str1[i] - 'a' + 1) % 26 + 'a' == str2[j]) {
            ++j;
        }
    }
    return str2[j] == '\0';
}
```

## Code (C++)

```cpp
class Solution {
public:
    bool canMakeSubsequence(string& str1, string& str2) {
        int j = 0, m = str2.size();
        for (char c : str1) {
            if (j < m && (c == str2[j] || (c + 1 - 'a') % 26 + 'a' == str2[j])) {
                if (++j == m) return true;
            }
        }
        return j == m;
    }
};
```

## Code (Java)

```java
class Solution {
    public boolean canMakeSubsequence(String str1, String str2) {
        int j = 0, m = str2.length();
        for (int i = 0; i < str1.length() && j < m; ++i) {
            char c = str1.charAt(i);
            if (c == str2.charAt(j) || (c - 'a' + 1) % 26 + 'a' == str2.charAt(j)) {
                ++j;
            }
        }
        return j == m;
    }
}
```

## Code (Python)

```python
class Solution:
    def canMakeSubsequence(self, str1: str, str2: str) -> bool:
        j, m = 0, len(str2)
        for c in str1:
            if j < m and (c == str2[j] or chr((ord(c) - ord('a') + 1) % 26 + ord('a')) == str2[j]):
                j += 1
                if j == m:
                    return True
        return j == m
```

## Code (Rust)

```rust
impl Solution {
    pub fn can_make_subsequence(str1: String, str2: String) -> bool {
        let (mut j, m) = (0, str2.len());
        let str2_bytes = str2.as_bytes();
        for c in str1.bytes() {
            if j < m && (c == str2_bytes[j] || (c - b'a' + 1) % 26 + b'a' == str2_bytes[j]) {
                j += 1;
                if j == m {
                    return true;
                }
            }
        }
        j == m
    }
}
```

## 🎯 **Contribute or Ask Questions:**
For more discussions, questions, or help with the solution, feel free to reach out on LinkedIn: [**Connect with Me!**](https://www.linkedin.com/in/het-patel-8b110525a/).

## <img src="https://github.com/user-attachments/assets/35f6838c-52f5-4e48-8a98-c5203f8c57e3" style="width:29px; color: #FFD700" alt="Star GIF"> **Enjoying the Solution?**  
If this helped you, please **star this repo** to support the efforts and keep it growing!
